package gov.va.vinci.dart.biz;

import java.util.Date;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestOperationalStudy extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Assert.assertNull(DartObjectFactory.getInstance().getOperationalStudyDAO().findById(0));
		
		try {
			OperationalStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", null, 5);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {
		}

		try {
			OperationalStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "", 5);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {
		}
		try {
			OperationalStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "123456789012345678901234567890123456789012345678901234567890", 5);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {
		}

		OperationalStudy study = OperationalStudy.create("short name", new Date(), new Date(), "Official Name - this is a test!", "DNS", 5);
		Assert.assertNotNull(study);
		
		Assert.assertEquals(study.getName(), "short name");
		
		int newId = study.getId();
		
		OperationalStudy study2 = OperationalStudy.findById(study.getId());
		Assert.assertNotNull(study2);
		Assert.assertEquals(study2.getName(), "short name");

		// update the short name and official name property
		study2.modify("new short name", study2.getStartDate(), study2.getEndDate(), "new official name", "modifier", 5);

		OperationalStudy study3 = OperationalStudy.findById(study.getId());
		Assert.assertNotNull(study3);
		Assert.assertEquals(study3.getName(), "new short name");
		Assert.assertEquals(study3.getOfficialName(), "new official name");

		OperationalStudy study4 = OperationalStudy.findByShortName("new short name");
		Assert.assertNotNull(study4);
		Assert.assertEquals(study4.getName(), "new short name");
		Assert.assertEquals(study4.getOfficialName(), "new official name");
	}
}
